// Record a video element and download the recording. Workaround download method for blob videos that cannot be downloaded directly.
function dl(videoElement) {
	let recordedChunks = [];

	const stream = videoElement.captureStream();

	mediaRecorder = new MediaRecorder(stream, { mimeType: "video/mp4" });

	mediaRecorder.ondataavailable = (event) => {
		if (event.data.size > 0) {
			recordedChunks.push(event.data);
		}
	};

	mediaRecorder.onstop = () => {
		const blob = new Blob(recordedChunks, { type: "video/mp4" });
		const url = URL.createObjectURL(blob);
		const a = document.createElement("a");
		a.href = url;
		a.download = `${Date.now()}.mp4`;
		document.body.appendChild(a);
		a.click();
		URL.revokeObjectURL(url);
	};

	videoElement.onplay = () => {
		mediaRecorder.start();
	};

	videoElement.onended = () => {
		mediaRecorder.stop();
	};

	videoElement.loop = false;
	videoElement.currentTime = 0;
	videoElement.play();
}